# AI Chat App

A modern AI chatbot application supporting both ChatGPT and Claude APIs, designed with ES5 compatibility and mobile-first responsive design based on the Telegram app interface.

## Features

- **Multi-Provider Support**: Switch between ChatGPT and Claude AI providers
- **Model Selection**: Choose from available models for each provider
- **Conversation Management**: Create, save, and delete chat conversations
- **Mobile-First Design**: Responsive interface optimized for BlackBerry and mobile devices
- **ES5 Compatible**: Works on older browsers and devices
- **Dark Theme**: Modern dark UI with smooth animations
- **Local Storage**: Conversations saved locally in browser
- **Settings Management**: Secure API key storage and system prompt configuration

## Supported Models

### ChatGPT
- GPT-3.5 Turbo
- GPT-4
- GPT-4 Turbo Preview

### Claude
- Claude 3 Haiku
- Claude 3 Sonnet
- Claude 3 Opus

## Installation

1. Install Python dependencies:
```bash
pip install -r requirements.txt
```

2. Run the Flask application:
```bash
python app.py
```

3. Open your browser and navigate to `http://localhost:8047`

## Configuration

1. Click the menu icon (⋯) in the top right corner
2. Select "Settings"
3. Enter your API keys:
   - **ChatGPT**: Get your API key from [OpenAI](https://platform.openai.com/api-keys)
   - **Claude**: Get your API key from [Anthropic](https://console.anthropic.com/)
4. Customize the system prompt if desired
5. Save settings

## Usage

1. **Start a New Chat**: Click "New Chat" in the sidebar
2. **Select Provider**: Choose between ChatGPT and Claude
3. **Select Model**: Pick your preferred model from the dropdown
4. **Send Messages**: Type your message and press Enter or click Send
5. **Manage Conversations**: View, switch between, or delete conversations from the sidebar

## API Endpoints

- `GET /api/aichat/settings` - Get current settings
- `POST /api/aichat/settings` - Save settings
- `POST /api/aichat/send` - Send message to AI
- `GET /api/aichat/models/<provider>` - Get available models

## Browser Compatibility

This application is designed to work on older browsers and devices, including:
- BlackBerry devices
- Internet Explorer 11+
- Chrome 30+
- Firefox 25+
- Safari 7+

## Security

- API keys are stored locally and only transmitted to their respective services
- Keys are partially masked in the UI for security
- No conversation data is sent to external servers (stored locally only)

## License

Created for BerryMuch OS by SW7FT
