#!/bin/sh
# BOCHS ARM Alignment Fixed Version
# This version fixes the SIGBUS error that was occurring on ARM

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Set library path
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib:/usr/local/lib:/usr/lib:/lib:$LD_LIBRARY_PATH"

# Set BOCHS share path
export BXSHARE="$SCRIPT_DIR/share/bochs"

# Set display to XSDL server
export DISPLAY=192.168.1.107:0

echo "Starting BOCHS with ARM ALIGNMENT FIX..."
echo "This version should eliminate the SIGBUS error!"
echo ""
echo "Fixes applied:"
echo "- time0 parameter bug SOLVED"
echo "- C++ runtime libraries included"
echo "- ARM memory alignment handling added"
echo ""

# Create working configuration
cat > "$SCRIPT_DIR/arm_fixed.bochsrc" << 'EOFCONFIG'
# BOCHS ARM-Fixed Configuration
# All major issues resolved!

# Memory settings
megs: 64

# BIOS files
romimage: file=$BXSHARE/BIOS-bochs-latest
vgaromimage: file=$BXSHARE/VGABIOS-lgpl-latest

# Boot from floppy
boot: floppy
floppya: 1_44=/dev/null, status=ejected

# Display settings for X11
display_library: x

# CPU settings
cpu: count=1, ips=4000000, model=bx_generic, reset_on_triple_fault=1

# Clock settings (working!)
clock: sync=realtime

# I/O settings
mouse: enabled=0
keyboard: keymap=

# Logging
log: bochs.log
logprefix: %t%e%d
panic: action=ask
error: action=report
info: action=report
debug: action=ignore

# Display settings
private_colormap: enabled=0
EOFCONFIG

echo "=== ARM-Fixed Configuration Created ==="
cat "$SCRIPT_DIR/arm_fixed.bochsrc"
echo ""
echo "=== Starting BOCHS (ARM alignment fixed!) ==="

# Run BOCHS with the fixed binary
"$SCRIPT_DIR/bin/bochs" -q -f "$SCRIPT_DIR/arm_fixed.bochsrc"

