#!/bin/sh
# BOCHS with Windows XP Image and XSDL Mouse Support
# This version boots XP.IMG and enables proper mouse/touch input

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Set library path
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib:/usr/local/lib:/usr/lib:/lib:$LD_LIBRARY_PATH"

# Set BOCHS share path
export BXSHARE="$SCRIPT_DIR/share/bochs"

# Set display to XSDL server
export DISPLAY=192.168.1.107:0

echo "=========================================="
echo "BOCHS - Windows XP Boot with Mouse Support"
echo "=========================================="
echo ""
echo "🖥️  Booting: /accounts/1000/removable/sdcard/BB10/XP.IMG"
echo "🖱️  Mouse: Enabled with XSDL touch support"
echo "⌨️  Keyboard: Full keyboard mapping enabled"
echo ""
echo "XSDL Touch Controls:"
echo "- Touch = Left mouse click"
echo "- Long press = Right mouse click"
echo "- Two finger tap = Middle click"
echo "- Pinch/zoom = Mouse wheel"
echo "=========================================="
echo ""

# Create Windows XP configuration with mouse support
cat > "$SCRIPT_DIR/xp_mouse.bochsrc" << 'EOFCONFIG'
# BOCHS Configuration for Windows XP with XSDL Mouse Support

# Memory settings (512MB for XP)
megs: 512

# BIOS files
romimage: file=$BXSHARE/BIOS-bochs-latest
vgaromimage: file=$BXSHARE/VGABIOS-lgpl-latest

# Boot from hard disk (XP.IMG)
boot: disk
ata0-master: type=disk, path="/accounts/1000/removable/sdcard/BB10/XP.IMG", mode=flat

# Display settings for X11 with XSDL
display_library: x

# CPU settings (optimized for XP)
cpu: count=1, ips=50000000, model=bx_generic, reset_on_triple_fault=1

# Clock settings
clock: sync=realtime

# Mouse settings - ENABLED for XSDL touch support
mouse: enabled=1, type=ps2, toggle=ctrl+mbutton

# Keyboard settings - full mapping for better compatibility
keyboard: keymap=, user_shortcut=none

# Sound (basic)
sb16: midimode=1, midi=none, wavemode=1, wave=none, loglevel=2, log=sb16.log, dmatimer=600000

# Network (disabled for now)
ne2k: enabled=0

# Logging (minimal for performance)
log: bochs.log
logprefix: %t%e%d
panic: action=ask
error: action=report
info: action=ignore
debug: action=ignore

# Display settings optimized for XSDL
private_colormap: enabled=0
fullscreen: enabled=0
screenmode: name="windowed"

# VGA settings
vga: extension=vbe, update_freq=60
EOFCONFIG

echo "=== Windows XP Configuration with Mouse Support Created ==="
cat "$SCRIPT_DIR/xp_mouse.bochsrc"
echo ""
echo "=== Starting BOCHS with Windows XP ==="
echo "Note: First boot may take several minutes..."
echo ""

# Run BOCHS with XP configuration
"$SCRIPT_DIR/bin/bochs" -q -f "$SCRIPT_DIR/xp_mouse.bochsrc"
