#!/bin/sh
# FINAL BOCHS XP Boot - All ARM alignment issues fixed
# This version should eliminate ALL SIGBUS errors including write_linear_qword

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Set library path
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib:/usr/local/lib:/usr/lib:/lib:$LD_LIBRARY_PATH"

# Set BOCHS share path
export BXSHARE="$SCRIPT_DIR/share/bochs"

# Set display to XSDL server
export DISPLAY=192.168.2.2:1

echo "=========================================="
echo "🎯 FINAL BOCHS XP BOOT - ALL FIXES APPLIED"
echo "=========================================="
echo ""
echo "✅ ARM Alignment Fixes Applied:"
echo "   - system_read_qword ✅"
echo "   - system_read_dword ✅" 
echo "   - system_read_word ✅"
echo "   - system_write_qword ✅"
echo "   - system_write_dword ✅"
echo "   - system_write_word ✅"
echo "   - write_linear_qword ✅ (NEW!)"
echo "   - write_linear_dword ✅ (NEW!)"
echo ""
echo "🖥️  Booting: /accounts/1000/removable/sdcard/BB10/XP.IMG"
echo "🖱️  Mouse: Enabled with XSDL touch support"
echo "⌨️  Keyboard: Full keyboard mapping"
echo "🔇  Sound: Disabled (prevents crashes)"
echo "🌐  Network: Disabled (prevents crashes)"
echo ""
echo "This should boot to Windows XP desktop without crashes!"
echo "=========================================="
echo ""

# Create final XP configuration with all fixes
cat > "$SCRIPT_DIR/final_xp.bochsrc" << 'EOFCONFIG'
# FINAL BOCHS Configuration for Windows XP
# All ARM alignment issues resolved + stability optimizations

# Memory settings (512MB for XP)
megs: 512

# BIOS files
romimage: file=$BXSHARE/BIOS-bochs-latest
vgaromimage: file=$BXSHARE/VGABIOS-lgpl-latest

# Boot from hard disk (XP.IMG)
boot: disk
ata0-master: type=disk, path="/accounts/1000/removable/sdcard/BB10/XP.IMG", mode=flat

# Display settings for XSDL
display_library: x

# CPU settings (optimized for stability)
cpu: count=1, ips=25000000, model=bx_generic, reset_on_triple_fault=1

# Clock settings
clock: sync=realtime

# Mouse - ENABLED with XSDL support
mouse: enabled=1, type=ps2, toggle=ctrl+mbutton

# Keyboard - full support
keyboard: keymap=, user_shortcut=none

# Sound - DISABLED (prevents crashes)
# sb16: disabled

# Network - DISABLED (prevents crashes)  
# ne2k: enabled=0

# Logging (minimal for performance)
log: bochs.log
logprefix: %t%e%d
panic: action=ask
error: action=report
info: action=ignore
debug: action=ignore

# Display settings optimized for XSDL
private_colormap: enabled=0
fullscreen: enabled=0
screenmode: name="windowed"

# VGA settings
vga: extension=vbe, update_freq=60

# Disable potentially problematic features
# pci: enabled=0
# usb_uhci: enabled=0
# usb_ohci: enabled=0
EOFCONFIG

echo "=== Final XP Configuration Created ==="
echo "Memory: 512MB"
echo "CPU IPS: 25M (reduced for stability)"
echo "Sound: Disabled"
echo "Network: Disabled"
echo "Mouse: Enabled"
echo ""
echo "=== Starting Windows XP (Final Version) ==="
echo "This should boot completely without SIGBUS errors!"
echo ""

# Run BOCHS with final configuration
"$SCRIPT_DIR/bin/bochs" -q -f "$SCRIPT_DIR/final_xp.bochsrc"
