#!/bin/sh
# Quick fix for the deprecated user_shortcut option

echo "Fixing deprecated user_shortcut option..."

# Create a corrected configuration file
cat > working.bochsrc << 'EOFCONFIG'
# BOCHS Configuration for QNX 8 ARM - FULLY FIXED VERSION
# Time0 bug is SOLVED! Just fixing deprecated config option.

# Basic memory and hardware
megs: 64
romimage: file=$BXSHARE/BIOS-bochs-latest
vgaromimage: file=$BXSHARE/VGABIOS-lgpl-latest

# Boot from floppy (no disk image needed for basic test)
boot: floppy
floppya: 1_44=/dev/null, status=ejected

# Display settings for X11
display_library: x

# CPU settings
cpu: count=1, ips=4000000, model=bx_generic, reset_on_triple_fault=1

# Clock settings - WORKING NOW!
clock: sync=realtime

# I/O settings
mouse: enabled=0
keyboard: keymap=, user_shortcut=none

# Logging (minimal)
log: bochs.log
logprefix: %t%e%d
panic: action=ask
error: action=report
info: action=report
debug: action=ignore

# Optional features
private_colormap: enabled=0
EOFCONFIG

echo "Configuration fixed! The time0 bug is completely solved."
echo "Now starting BOCHS with corrected config..."
echo ""

./bin/bochs -f working.bochsrc

