#!/bin/sh
# BOCHS QNX 8 ARM Launcher Script - MKTIME FIXED VERSION
# This version fixes the critical mktime() bug that caused time0 parameter errors

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Set library path to include both local lib and system lib
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib:/usr/local/lib:/usr/lib:/lib:$LD_LIBRARY_PATH"

# Set BOCHS share path
export BXSHARE="$SCRIPT_DIR/share/bochs"

# Set display to XSDL server
export DISPLAY=192.168.1.107:0

echo "Starting BOCHS for QNX 8 ARM (MKTIME FIXED VERSION)..."
echo "Script directory: $SCRIPT_DIR"
echo "Library path: $LD_LIBRARY_PATH"
echo "Display: $DISPLAY"
echo "BIOS Path: $BXSHARE"
echo ""
echo "CRITICAL: Run this directly on the QNX device, NOT over SSH!"
echo "SSH interferes with X11 display connections."
echo ""
echo "=== MKTIME FIX APPLIED ==="
echo "This version fixes the mktime() failure on QNX that caused:"
echo "  >>PANIC<< numerical parameter 'time0' was set to 1, which is out of range 4294967295 to 4294967295"
echo ""

# Create working config file
cat > "$SCRIPT_DIR/working.bochsrc" << 'EOFCONFIG'
# BOCHS Configuration for QNX 8 ARM - MKTIME FIXED VERSION
# This version should finally work without time0 parameter errors!

# Basic memory and hardware
megs: 64
romimage: file=$BXSHARE/BIOS-bochs-latest
vgaromimage: file=$BXSHARE/VGABIOS-lgpl-latest

# Boot from floppy (no disk image needed for basic test)
boot: floppy
floppya: 1_44=/dev/null, status=ejected

# Display settings for X11
display_library: x

# CPU settings
cpu: count=1, ips=4000000, model=bx_generic, reset_on_triple_fault=1

# Clock settings - should now work with mktime fix!
clock: sync=realtime

# I/O settings
mouse: enabled=0
keyboard: keymap=

# Logging (minimal)
log: bochs.log
logprefix: %t%e%d
panic: action=ask
error: action=report
info: action=report
debug: action=ignore

# Optional features
private_colormap: enabled=0
user_shortcut: keys=none
EOFCONFIG

echo "=== Configuration created with mktime fix ==="
cat "$SCRIPT_DIR/working.bochsrc"
echo ""
echo "=== Starting BOCHS (should work now!) ==="

# Launch BOCHS from the script directory
cd "$SCRIPT_DIR"
./bin/bochs -f working.bochsrc "$@"

