#!/bin/sh
# BOCHS Safe Mode - Addresses ARM alignment issues

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Set library path
export LD_LIBRARY_PATH="$SCRIPT_DIR/lib:/usr/local/lib:/usr/lib:/lib:$LD_LIBRARY_PATH"

# Set BOCHS share path
export BXSHARE="$SCRIPT_DIR/share/bochs"

# Set display to XSDL server
export DISPLAY=192.168.1.107:0

echo "Starting BOCHS in SAFE MODE for ARM..."
echo "This version uses conservative settings to avoid bus errors."
echo ""

# Create ARM-safe configuration
cat > "$SCRIPT_DIR/safe.bochsrc" << 'EOFCONFIG'
# BOCHS ARM-Safe Configuration
# Conservative settings to avoid bus errors on ARM processors

# Reduced memory to avoid alignment issues
megs: 32

# BIOS files
romimage: file=$BXSHARE/BIOS-bochs-latest
vgaromimage: file=$BXSHARE/VGABIOS-lgpl-latest

# Boot from floppy
boot: floppy
floppya: 1_44=/dev/null, status=ejected

# Display settings for X11
display_library: x

# Conservative CPU settings for ARM compatibility
cpu: count=1, ips=1000000, model=bx_generic, reset_on_triple_fault=1

# Clock settings (working!)
clock: sync=none

# I/O settings
mouse: enabled=0
keyboard: keymap=

# Minimal logging to reduce memory operations
log: -
panic: action=fatal
error: action=ignore
info: action=ignore
debug: action=ignore

# Conservative display settings
private_colormap: enabled=0

# Disable features that might cause alignment issues
# (These are automatically disabled in our build anyway)
EOFCONFIG

echo "=== ARM-Safe Configuration Created ==="
cat "$SCRIPT_DIR/safe.bochsrc"
echo ""
echo "=== Starting BOCHS in Safe Mode ==="

# Run with conservative settings
"$SCRIPT_DIR/bin/bochs" -q -f "$SCRIPT_DIR/safe.bochsrc"

